/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.adapters.MobSpawnerAdapter;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessorSerializer;
import dev.toma.gunsrpg.common.quests.quest.area.IMobTargettingContext;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawnProcessorType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class SetEntityControllerProcessor
implements IMobSpawnProcessor {
    private final MobSpawnProcessorType<SetEntityControllerProcessor> type;
    private final EntityType<? extends LivingEntity> controllerType;
    private final List<IMobSpawnProcessor> processorList;

    private SetEntityControllerProcessor(MobSpawnProcessorType<SetEntityControllerProcessor> type, EntityType<? extends LivingEntity> controllerType, List<IMobSpawnProcessor> processorList) {
        this.type = type;
        this.controllerType = controllerType;
        this.processorList = processorList;
    }

    public MobSpawnProcessorType<SetEntityControllerProcessor> getType() {
        return this.type;
    }

    @Override
    public void processMobSpawn(LivingEntity entity, IMobTargettingContext targettingContext) {
        World world = entity.field_70170_p;
        LivingEntity controller = (LivingEntity)this.controllerType.func_200721_a(world);
        controller.func_226286_f_(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        world.func_217376_c((Entity)controller);
        this.processorList.forEach(processor -> processor.processMobSpawn(controller, targettingContext));
        controller.func_184220_m((Entity)entity);
        targettingContext.processMobSpawn(controller);
    }

    public static final class Serializer
    implements IMobSpawnProcessorSerializer<SetEntityControllerProcessor> {
        @Override
        public SetEntityControllerProcessor deserialize(MobSpawnProcessorType<SetEntityControllerProcessor> type, JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"controller"));
            EntityType<? extends LivingEntity> entity = MobSpawnerAdapter.tryParseAsLivingEntity(id);
            List<Object> processorList = Collections.emptyList();
            if (object.has("processors")) {
                processorList = JsonHelper.deserializeAsList("processors", object, MobSpawnerAdapter::resolveSpawnProcessor);
            }
            return new SetEntityControllerProcessor(type, entity, processorList);
        }

        @Override
        public void toNbt(SetEntityControllerProcessor processor, CompoundNBT nbt) {
            nbt.func_74778_a("controller", processor.controllerType.getRegistryName().toString());
            ListNBT list = new ListNBT();
            processor.processorList.stream().map(this::serializeProcessor).forEach(arg_0 -> list.add(arg_0));
            nbt.func_218657_a("processors", (INBT)list);
        }

        @Override
        public SetEntityControllerProcessor fromNbt(MobSpawnProcessorType<SetEntityControllerProcessor> type, CompoundNBT nbt) {
            ResourceLocation entityId = new ResourceLocation(nbt.func_74779_i("controller"));
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId);
            ListNBT listNBT = nbt.func_150295_c("processors", 10);
            List list = listNBT.stream().map(inbt -> MobSpawnProcessorType.fromNbt((CompoundNBT)inbt)).collect(Collectors.toList());
            return new SetEntityControllerProcessor(type, entityType, list);
        }

        private <P extends IMobSpawnProcessor> CompoundNBT serializeProcessor(P processor) {
            MobSpawnProcessorType<?> type = processor.getType();
            return type.toNbt(processor);
        }
    }
}

